/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>

#include "resource.h"
#include "about.h"
#include "url_ctrl.h"

/**/
BOOL OnAboutDlgCommand(HWND hwnd, WORD wNotifyCode, WORD wID, HWND hwndCtl)
{
	switch(wID)
	{
		case ID_OK:
			return EndDialog(hwnd, 0);
	}

	return FALSE;
}
/**/
BOOL CALLBACK AboutDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			StaticToURLControl(hwnd, IDC_WEBSITE, "http://tomp.arsware.org", -1);
			StaticToURLControl(hwnd, IDC_EMAIL, "mailto:tpicot@xtra.co.nz", -1);
			break;
		case WM_COMMAND:
			return OnAboutDlgCommand(hwnd, HIWORD(wParam), LOWORD(wParam), (HWND) lParam);
		case WM_CLOSE:
			CleanupURLControl();
			return EndDialog(hwnd, 0);
	}

	return FALSE;
}
