/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>

#include "configuration.h"

#include "main.h"

char	g_filename[] = "config.ini";	/* self-explanatory */
char	g_filename_path[256];			/* storage area for ini file name + path */

bcfg	*bc;

char *GetINIPath(void)
{
	/*~~~~~~~~~~~*/
	char	*p;
	/*~~~~~~~~~~~*/

	GetModuleFileName(g_inst, g_filename_path, sizeof(g_filename_path));
	p = g_filename_path;
	while(strchr(p, '\\'))
	{	/* while there are more separators */
		p = strchr(p, '\\');	/* point to next separator */
		p++;					/* point to char after last separator */
	}

	*p = '\0';					/* terminate string */
	strcat(g_filename_path, g_filename);
	return g_filename_path;
}

void LoadLookFromBARCONFIG(HWND hDlg)
{
	/*~~~~~~~~~~~~~~~*/
	int a, b, c, d;
	/*~~~~~~~~~~~~~~~*/

	a = bc->rt.left;
	b = bc->rt.top;
	c = bc->rt.right - bc->rt.left;
	d = bc->rt.bottom - bc->rt.top;
	MoveWindow(hDlg, a, b, c, d, TRUE);
	ShowWindow(g_bar, bc->show);

	/* if(bc->alttab) SetWindowLong(hDlg, GWL_EXSTYLE, WS_EX_APPWINDOW); else
	 * SetWindowLong(hDlg, GWL_EXSTYLE, WS_EX_TOOLWINDOW);
	 */
}

void SaveLookInBARCONFIG(void)
{
	/*~~~~~~~~~~~*/
	RECT	rc;
	/*~~~~~~~~~~~*/

	GetWindowRect(g_bar, &rc);
	bc->rt = rc;				/* Store position */
}

bcfg *ReadConfig(void)
{
	/*~~~~~~~~~~~~*/
	int		i;
	bcfg	*bc;
	/*~~~~~~~~~~~~*/

	bc = (bcfg *)malloc(sizeof(bcfg));
	i = GetPrivateProfileStruct("config", "config", bc, sizeof(bcfg), GetINIPath());
	if(!i)
	{
		bc->ontop = TRUE;
		SetRect(&bc->rt, 0, 0, 321, 22);
		bc->show = TRUE;
		bc->animated = TRUE;
		bc->autorollup = TRUE;
		bc->wHotkey = 0;
		bc->automin = 0;
		bc->width = 320;
		bc->height = 22;
		bc->alttab = 1;
		bc->newwindow = 0;
	}

	return bc;
}

void WriteConfig(bcfg *bc)
{
	WritePrivateProfileStruct("config", "config", bc, sizeof(bcfg), GetINIPath());
}

int FreeConfig(bcfg *bc)
{
	/*~~~~~~~~*/
	int ret;
	/*~~~~~~~~*/

	if(bc)
	{
		free(bc);
		ret = 1;
	}
	else
		ret = 0;

	return ret;
}
