/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>
#include <Shlwapi.h>

#include "corefunctions.h"
#include "sizefunctions.h"
#include "resource.h"
#include "options.h"
#include "main.h"
#include "alias.h"
#include "functionconstruction.h"
#include "options.h"
#include "aliasmanager.h"
#include "macro.h"
#include "about.h"
#include "configuration.h"

int exitbar(char *command)
{
	SaveLookInBARCONFIG();
	DestroyWindow(g_main);
	return TRUE;
}

int hidebar(char *command)
{
	ShowWindow(g_bar, FALSE);
	return TRUE;
}

int options(char *command)
{
	DoPropertySheet(g_bar);
	return TRUE;
}

int alias(char *command)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	char	*p;
	char	aliasnamecommand[1000];
	char	*aliasname;
	char	*aliascommand;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	p = StrStrI(command, "@set ");
	if(!p) p = StrStrI(command, "@add ");

	if(p)
	{
		p = p + 5;	/* name=command */
		strcpy(aliasnamecommand, p);
		aliasname = strtok(aliasnamecommand, "=");
		aliascommand = strtok(NULL, "=");
		if(aliasname && aliascommand)
		{
			AddNewAlias(aliasname, aliascommand);
		}
		else
		{
			MessageBox
			(
				g_bar,
				"Incorrect format for alias. Should be: @set aliasname=toexecute",
				"Error",
				MB_ICONWARNING
			);
		}

		return TRUE;
	}

	if(!p) p = StrStrI(command, "@remove ");
	if(p)
	{
		p = p + 8;	/* name */
		if(!RemoveAlias(p))
		{
			MessageBox
			(
				g_bar,
				"Could not find alias to remove! Check syntax: @remove nameofalias",
				"Error",
				MB_ICONWARNING
			);
		}

		return TRUE;
	}

	if(!p) p = StrStrI(command, "@update ");
	if(p)
	{
		p = p + 8;	/* name */
		strcpy(aliasnamecommand, p);
		aliasname = strtok(aliasnamecommand, "=");
		aliascommand = strtok(NULL, "=");
		if(aliasname && aliascommand)
		{
			if(!UpdateAlias(aliasname, aliascommand))
			{
				if(!AddNewAlias(aliasname, aliascommand)) return FALSE;
			}

			return TRUE;
		}
		else
		{
			MessageBox
			(
				g_bar,
				"Incorrect format for alias. Should be: @update oldaliasname=toexecute",
				"Error",
				MB_ICONWARNING
			);
			return FALSE;
		}

		return TRUE;
	}

	if(!p) p = StrStrI(command, "@reload");
	if(p)
	{
		SaveAllAlias();
		DestoryAliasTable();
		CreateAliasTable();
		LoadAllAlias();
		return TRUE;
	}

	if(!p)
	{
		if(strcmp(command, "@") == 0)
		{
			DialogBox(g_inst, MAKEINTRESOURCE(IDD_ALIASMANAGER), g_bar, AliasManagerDlgProc);
			return TRUE;
		}
	}

	MessageBox(g_bar, "Syntax Error: Consult documentation", "Error", MB_ICONWARNING);

	return FALSE;
}

int macro(char *command)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	char	*p;
	char	macronamecommand[1000];
	char	*macroname;
	char	*macrocommand;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	p = StrStrI(command, "#set ");
	if(!p) p = StrStrI(command, "#add ");

	if(p)
	{
		p = p + 5;	/* name=command */
		strcpy(macronamecommand, p);
		macroname = strtok(macronamecommand, "=");
		macrocommand = strtok(NULL, "=");
		if(macroname && macrocommand)
		{
			AddNewMacro(macroname, macrocommand);
		}
		else
		{
			MessageBox
			(
				g_bar,
				"Incorrect format for macro. Should be: #set macroname=toexecute",
				"Error",
				MB_ICONWARNING
			);
		}

		return TRUE;
	}

	if(!p) p = StrStrI(command, "#remove ");
	if(p)
	{
		p = p + 8;	/* name */
		if(!RemoveMacro(p))
		{
			MessageBox
			(
				g_bar,
				"Could not find macro to remove! Check syntax: #remove nameofmacro",
				"Error",
				MB_ICONWARNING
			);
		}

		return TRUE;
	}

	if(!p) p = StrStrI(command, "#update ");
	if(p)
	{
		p = p + 8;	/* name */
		strcpy(macronamecommand, p);
		macroname = strtok(macronamecommand, "=");
		macrocommand = strtok(NULL, "=");
		if(macroname && macrocommand)
		{
			if(!UpdateMacro(macroname, macrocommand))
			{
				if(!AddNewMacro(macroname, macrocommand)) return FALSE;
			}

			return TRUE;
		}
		else
		{
			MessageBox
			(
				g_bar,
				"Incorrect format for macro. Should be: #update oldmacroname=toexecute",
				"Error",
				MB_ICONWARNING
			);
			return FALSE;
		}

		return TRUE;
	}

	if(!p) p = StrStrI(command, "#reload");
	if(p)
	{
		SaveAllMacro();
		DestoryMacroTable();
		CreateMacroTable();
		LoadAllMacro();
		return TRUE;
	}

	if(!p)
	{
		if(strcmp(command, "#") == 0)
		{
			MessageBox(g_bar, "Show macro manager", "Show macro manager", MB_OK);
			return TRUE;
		}
	}

	MessageBox(g_bar, "Syntax Error: Consult documentation", "Error", MB_ICONWARNING);

	return FALSE;
}

int desktop(char *command)
{
	keybd_event(VK_LWIN, 0, 0, 0);
	keybd_event(0x4D, 0, 0, 0);
	keybd_event(VK_LWIN, 0, KEYEVENTF_KEYUP, 0);
	return TRUE;
}

int about(char *command)
{
	DialogBox(g_inst, MAKEINTRESOURCE(IDD_ABOUT), g_bar, AboutDlgProc);
	return TRUE;
}
