/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>

#include "sizefunctions.h"
#include "configuration.h"
#include "main.h"
#include "resource.h"

int ToggleHidden(void)
{
	/*~~~~~~*/
	int i;
	/*~~~~~~*/

	i = IsWindowVisible(g_bar);
	if(i)
	{
		/* Showing, so hide */
		ShowWindow(g_bar, SW_HIDE);
		return FALSE;
	}
	else
	{
		/* Hidden, so show */
		ShowWindow(g_bar, SW_SHOW);
		return TRUE;
	}
}

BOOL IsRolledOut(HWND hDlg)
{
	/*~~~~~~~~~~~*/
	RECT	rc;
	int		i;
	/*~~~~~~~~~~~*/

	GetWindowRect(hDlg, &rc);
	i = (rc.right - rc.left);

	if(i == 14)						/* Rolled Up */
		return FALSE;
	else
		return TRUE;
}

void SetRollup(HWND hDlg, BOOL action)
{
	/*~~~~~~~~~~~*/
	RECT	rc;
	int		i;
	/*~~~~~~~~~~~*/

	GetWindowRect(hDlg, &rc);
	i = (rc.right - rc.left);

	if(action == TRUE)
	{
		SaveLookInBARCONFIG();
		if(bc->animated)
		{
			while(i >= 14)
			{
				MoveWindow(hDlg, rc.left, rc.top, i, (rc.bottom - rc.top), TRUE);
				i--;
			}
		}
		else
			MoveWindow(hDlg, rc.left, rc.top, 14, (rc.bottom - rc.top), TRUE);
	}
	else
	{
		MoveWindow(hDlg, rc.left, rc.top, bc->width, bc->height, TRUE);
		UpdateEditBoxSize(hDlg);
	}
}

void ToggleRollup(HWND hDlg)
{
	/*~~~~~~*/
	int i;
	/*~~~~~~*/

	i = IsRolledOut(hDlg);			/* Long */
	if(i) SetRollup(hDlg, TRUE);	/* Make short.. */
	else						/* Short */
		SetRollup(hDlg, FALSE); /* Make long.. */
}

void UpdateEditBoxSize(HWND hDlg)
{
	/*~~~~~~~~~~~~~~~~~~~~*/
	RECT	rEdit, rBar;
	HWND	hEdit;
	int		i;
	/*~~~~~~~~~~~~~~~~~~~~*/

	hEdit = GetDlgItem(hDlg, IDC_COMMAND);
	GetClientRect(hEdit, &rEdit);
	GetWindowRect(hDlg, &rBar);
	i = (rBar.right - rBar.left) - 14;	/* Adjustment for the grey button */
	i = i - rEdit.right;				/* Difference to inflate.. */
	rEdit.right = rEdit.right + i;
	MoveWindow(hEdit, 13, 0, rEdit.right, bc->height, TRUE);
}
