/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>

#include "snap.h"

int cx, cy;

BOOL IsClose(int a, int b)
{
	return abs(a - b) < 10;
}

BOOL OnMoving(HWND hwnd, LPRECT rect)
{
	/*~~~~~~~~~~~~~~~~*/
	POINT	cur_pos;
	RECT	wa;
	/*~~~~~~~~~~~~~~~~*/

	GetCursorPos(&cur_pos);
	OffsetRect(rect, cur_pos.x - (rect->left + cx), cur_pos.y - (rect->top + cy));
	SystemParametersInfo(SPI_GETWORKAREA, 0, &wa, 0);

	if(IsClose(rect->left, wa.left))
		OffsetRect(rect, wa.left - rect->left, 0);
	else if(IsClose(wa.right, rect->right))
		OffsetRect(rect, wa.right - rect->right, 0);

	if(IsClose(rect->top, wa.top))
		OffsetRect(rect, 0, wa.top - rect->top);
	else if(IsClose(wa.bottom, rect->bottom))
		OffsetRect(rect, 0, wa.bottom - rect->bottom);

	return TRUE;
}

void OnEnterSizeMove(HWND hwnd)
{
	/*~~~~~~~~~~~~~~~~~*/
	POINT	cur_pos;
	RECT	rcWindow;
	/*~~~~~~~~~~~~~~~~~*/

	GetWindowRect(hwnd, &rcWindow);
	GetCursorPos(&cur_pos);
	cx = cur_pos.x - rcWindow.left;
	cy = cur_pos.y - rcWindow.top;
}
