/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <errno.h>
#include <string.h>
#include <windows.h>

#include "stringfunctions.h"

int TrimCRLF(char *line)
{
	/*~~~~~~~~~~~*/
	char	*p;
	/*~~~~~~~~~~~*/

	p = strchr(line, '\r');
	if(p) *p = '\0';	/* kill CR */
	p = strchr(line, '\n');
	if(p) *p = '\0';	/* kill LF */
	return TRUE;
}

int TrimWhiteSpace(char *line)
{
	/*~~~~~~~~~~~~~~~~~~*/
	char	*p = line;
	/*~~~~~~~~~~~~~~~~~~*/

	while(*p && (*p == ' ' || *p == '\t')) ++p; /* skip whitespace */
	while(*p)
	{
		*line++ = *p++;
	}

	*line = '\0';	/* shift it the left */
	return TRUE;
}

int IsBlankLine(char *line)
{
	while(*line && (*line == ' ' || *line == '\t')) ++line; /* skip whitespace */
	return line == line + strlen(line);
}

int StripComments(char *line)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	char	*p = strchr(line, '#');
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	while(p && p != line && (*(p - 1) == '\\')) p = strchr(p + 1, '#');
	if(p) *p = '\0';
	return TRUE;
}
