#include <windows.h>

#include "resource.h"
#include "about.h"
#include "url_ctrl.h"

BOOL OnAboutDlgCommand(HWND hwnd, WORD wNotifyCode, WORD wID, HWND hwndCtl)
{
	switch(wID)
	{
		case WM_CLOSE:
			return EndDialog(hwnd, 0);
	}

	return FALSE;
}

BOOL CALLBACK AboutDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			StaticToURLControl(hwnd, IDC_WEBSITE2, "http://www.tompicot.com/on_top", -1);
			StaticToURLControl(hwnd, IDC_EMAIL, "mailto:tom@tompicot.com", -1);
			break;
		case WM_COMMAND:
			return OnAboutDlgCommand(hwnd, HIWORD(wParam), LOWORD(wParam), (HWND) lParam);
		case WM_CLOSE:
			CleanupURLControl();
			return EndDialog(hwnd, 0);
	}

	return FALSE;
}
